% Function: This is the program that calculates the mean between each entry
% of two different matrices

% Inputs:
% Matrix_(1/2) - a matrix whose elements are averaged for the output, 
%    primarily the median value matrix from each replicate

% Outputs:
% MatrixMean - a matrix array of the same dimensions as Matrix_1/2, whose
%    values are the mean of the entries of the two input matrices

function [MatrixMean] = MatrixMean(Matrix_1,Matrix_2)

% determine the size of Matrix_1 & Matrix_2, where row = # probes and col 
% = # IPs 
[row,col] = size(Matrix_1);

% initialize empty matrix of length(rows) -> probe & width(cols) -> ips, 
% to store the respective outputs
MatrixMean = zeros(row,col);

% loop over the rows (Probes)
parfor i=1:row
     
    % loop over the cols (IPs)
    for j=1:col
       
       % compute the average of the ith row and jth col of the two input
       % matrices and stores the value in the proper cell of the output
       % matrix
       MatrixMean(i,j) = nanmean([Matrix_1(i,j), Matrix_2(i,j)]);
        
    end
    
end